/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.compat.iris;

import com.vicmatskiv.pointblank.client.render.RenderTypeProvider;
import java.lang.reflect.InvocationTargetException;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class IrisCompat {
    private static final Logger LOGGER = LogManager.getLogger((String)"pointblank");
    private static IrisCompat instance;

    public static IrisCompat getInstance() {
        if (instance == null) {
            ModFileInfo shadersModFileInfo = LoadingModList.get().getModFileById("oculus");
            if (shadersModFileInfo == null) {
                shadersModFileInfo = LoadingModList.get().getModFileById("iris");
            }
            if (shadersModFileInfo != null) {
                String irisClassName = shadersModFileInfo.versionString().startsWith("1.6.") ? "com.vicmatskiv.pointblank.compat.iris.IrisCompatImpl16" : "com.vicmatskiv.pointblank.compat.iris.IrisCompatImpl";
                try {
                    Class<?> irisClass = Class.forName(irisClassName);
                    instance = (IrisCompat)irisClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    LOGGER.info("Compatibility with Oculus/Iris version {} enabled", (Object)shadersModFileInfo.versionString());
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoClassDefFoundError | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    LOGGER.error("Oculus mod version {} detected, but compatibility could not be enabled. This is likely due to an outdated and/or incompatible version of the Oculus mod. Please ensure you have Oculus version 1.7.0 or later installed.", (Object)shadersModFileInfo.versionString(), (Object)e);
                }
            }
            if (instance == null) {
                instance = new IrisCompat(){};
            }
        }
        return instance;
    }

    public boolean isIrisLoaded() {
        return false;
    }

    public boolean isShaderPackEnabled() {
        return false;
    }

    public boolean isRenderingShadows() {
        return false;
    }

    public void onStartRenderShadows() {
        throw new UnsupportedOperationException();
    }

    public void onEndRenderShadows() {
        throw new UnsupportedOperationException();
    }

    public RenderTypeProvider getRenderTypeProvider() {
        throw new UnsupportedOperationException();
    }

    public int getColorBalance() {
        return -1;
    }
}

