/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.train;

import com.google.common.collect.ImmutableMap;
import de.mrjulsen.crn.client.ClientWrapper;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.lang.CustomLanguage;
import de.mrjulsen.crn.data.train.TrainData;
import de.mrjulsen.crn.exceptions.RuntimeSideException;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.data.Single;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class TrainStatus {
    private static final Registry REGISTRY = Registry.create("createrailwaysnavigator");
    public static final TrainStatus DEFAULT_DELAY = REGISTRY.registerDefault("default_delay", new TrainStatus(TrainStatusCategory.TRAIN, TrainStatusType.DELAY, () -> CustomLanguage.translate("gui.createrailwaysnavigator.train_status.unknown_delay"), null));
    public static final TrainStatus DELAY_FROM_PREVIOUS_JOURNEY = REGISTRY.registerDefault("delay_from_previous_journey", new TrainStatus(TrainStatusCategory.TRAIN, TrainStatusType.DELAY, () -> CustomLanguage.translate("gui.createrailwaysnavigator.train_status.delay_previous_journey"), null));
    public static final TrainStatus CANCELLED = REGISTRY.registerDefault("cancelled", new TrainStatus(TrainStatusCategory.TRAIN, TrainStatusType.DELAY, () -> CustomLanguage.translate("gui.createrailwaysnavigator.route_overview.cancelled"), null));
    public static final int HEIGHT = 9;
    private final TrainStatusType importance;
    private final TrainStatusCategory category;
    private final Supplier<MutableComponent> text;
    private final Predicate<TrainData> trigger;
    private ResourceLocation location;

    public TrainStatus(TrainStatusCategory category, TrainStatusType importance, Supplier<MutableComponent> text, Predicate<TrainData> trigger) {
        this.importance = importance;
        this.category = category;
        this.text = text;
        this.trigger = trigger;
    }

    public TrainStatusType getImportance() {
        return this.importance;
    }

    public MutableComponent getText() {
        return this.text.get();
    }

    public boolean isTriggerd(TrainData data) {
        return this.trigger != null && this.trigger.test(data);
    }

    public CompiledTrainStatus compile() {
        return new CompiledTrainStatus(this.location, this.category, this.importance, (Component)this.getText());
    }

    public ResourceLocation getLocation() {
        return this.location;
    }

    private void setLocation(ResourceLocation location) {
        this.location = location;
    }

    public static enum TrainStatusType {
        MESSAGE_DEFAULT(0, -1),
        MESSAGE_WARN(1, ChatFormatting.GOLD.m_126665_()),
        MESSAGE_IMPORTANT(2, -48574),
        DELAY(3, -48574);

        private final byte index;
        private final int color;

        private TrainStatusType(byte index, int color) {
            this.index = index;
            this.color = color;
        }

        public byte getIndex() {
            return this.index;
        }

        public int getColor() {
            return this.color;
        }

        public static TrainStatusType getByIndex(int index) {
            return Arrays.stream(TrainStatusType.values()).filter(x -> x.getIndex() == index).findFirst().orElse(MESSAGE_DEFAULT);
        }
    }

    public static enum TrainStatusCategory {
        TRAIN(0),
        STATION(1);

        private final byte index;

        private TrainStatusCategory(byte index) {
            this.index = index;
        }

        public byte getIndex() {
            return this.index;
        }

        public static TrainStatusCategory getByIndex(int index) {
            return Arrays.stream(TrainStatusCategory.values()).filter(x -> x.getIndex() == index).findFirst().orElse(TRAIN);
        }
    }

    public record CompiledTrainStatus(ResourceLocation id, TrainStatusCategory category, TrainStatusType type, Component text) {
        public static final String NBT_CATEGORY = "Category";
        public static final String NBT_TYPE = "Type";
        public static final String NBT_TEXT = "Text";
        public static final String NBT_REASON = "Reason";

        public int render(Graphics graphics, Single<Font> font, int x, int y, int maxWidth) {
            int color = this.type().getColor();
            float scale = 0.75f;
            graphics.poseStack().m_85836_();
            graphics.poseStack().m_252880_((float)x, (float)y, 0.0f);
            GuiUtils.setTint((int)color);
            ModGuiIcons.IMPORTANT.render(graphics, -4, -3);
            graphics.poseStack().m_85841_(0.75f, 0.75f, 1.0f);
            int height = (int)((float)ClientWrapper.renderMultilineLabelSafe(graphics, 13, 2, (Font)font.getFirst(), this.text(), (int)((float)maxWidth / 0.75f), color) * 0.75f);
            graphics.poseStack().m_85849_();
            return Math.max(9, height + 2);
        }

        public static List<CompiledTrainStatus> load(Collection<ResourceLocation> ids) throws RuntimeSideException {
            if (Platform.getEnvironment() == Env.SERVER) {
                throw new RuntimeSideException(true);
            }
            ArrayList<CompiledTrainStatus> status = new ArrayList<CompiledTrainStatus>(ids.size());
            for (ResourceLocation loc : ids) {
                status.add(((TrainStatus)Registry.getRegisteredStatus().get((Object)loc)).compile());
            }
            return status;
        }

        public static CompiledTrainStatus load(ResourceLocation id) throws RuntimeSideException {
            if (Platform.getEnvironment() == Env.SERVER) {
                throw new RuntimeSideException(true);
            }
            return ((TrainStatus)Registry.getRegisteredStatus().get((Object)id)).compile();
        }
    }

    public static class Registry {
        private static final Map<ResourceLocation, TrainStatus> registeredStatusInfos = new HashMap<ResourceLocation, TrainStatus>();
        private final String modid;

        private Registry(String modid) {
            this.modid = modid;
        }

        public static Registry create(String modid) {
            return new Registry(modid);
        }

        public static ImmutableMap<ResourceLocation, TrainStatus> getRegisteredStatus() {
            return ImmutableMap.copyOf(registeredStatusInfos);
        }

        public TrainStatus register(String name, TrainStatus statusPattern) {
            ResourceLocation loc = new ResourceLocation(this.modid, name);
            statusPattern.setLocation(loc);
            registeredStatusInfos.put(loc, statusPattern);
            return statusPattern;
        }

        public TrainStatus registerDefault(String name, TrainStatus statusPattern) {
            ResourceLocation loc = new ResourceLocation(this.modid, name);
            statusPattern.setLocation(loc);
            registeredStatusInfos.put(loc, statusPattern);
            return statusPattern;
        }

        public TrainStatus unregister(ResourceLocation location) {
            return registeredStatusInfos.remove(location);
        }

        public TrainStatus get(ResourceLocation location) {
            return registeredStatusInfos.get(location);
        }

        public boolean isRegistered(ResourceLocation location) {
            return registeredStatusInfos.containsKey(location);
        }

        public void delete(String modid) {
            registeredStatusInfos.keySet().removeIf(x -> x.m_135827_().equals(modid));
        }
    }
}

