/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.forge;

import java.util.Objects;
import mcp.mobius.waila.WailaClient;
import mcp.mobius.waila.command.CommonCommand;
import mcp.mobius.waila.forge.ForgeClientCommand;
import mcp.mobius.waila.gui.hud.TooltipRenderer;
import mcp.mobius.waila.gui.hud.theme.BuiltinThemeLoader;
import mcp.mobius.waila.gui.screen.WailaConfigScreen;
import mcp.mobius.waila.network.Packets;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.Connection;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="waila", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ForgeWailaClient
extends WailaClient {
    @SubscribeEvent
    static void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            Packets.initClient();
            ForgeWailaClient.registerConfigScreen();
        });
    }

    @SubscribeEvent
    static void addReloadListener(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)new BuiltinThemeLoader());
    }

    static void registerConfigScreen() {
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((mc, screen) -> new WailaConfigScreen((Screen)screen)));
    }

    @Mod(value="wthit")
    @Mod.EventBusSubscriber(modid="wthit", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class HahaBorgeGoBrrrr {
        @SubscribeEvent
        static void clientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> ForgeWailaClient.registerConfigScreen());
        }
    }

    @Mod.EventBusSubscriber(modid="waila", value={Dist.CLIENT})
    static class Subscriber {
        Subscriber() {
        }

        @SubscribeEvent
        static void registerClientCommands(RegisterClientCommandsEvent event) {
            ((CommonCommand)new ForgeClientCommand()).register(event.getDispatcher());
        }

        @SubscribeEvent
        static void renderGui(RenderGuiEvent.Post event) {
            TooltipRenderer.render(event.getGuiGraphics(), event.getPartialTick());
        }

        @SubscribeEvent
        static void clientTick(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                ForgeWailaClient.onClientTick();
            }
        }

        @SubscribeEvent
        static void itemTooltip(ItemTooltipEvent event) {
            ForgeWailaClient.onItemTooltip(event.getItemStack(), event.getToolTip());
        }

        @SubscribeEvent
        static void loggingIn(ClientPlayerNetworkEvent.LoggingIn event) {
            ForgeWailaClient.onServerLogIn(Objects.requireNonNull(event.getConnection()));
        }

        @SubscribeEvent
        static void loggingOut(ClientPlayerNetworkEvent.LoggingOut event) {
            Connection connection = event.getConnection();
            if (connection != null) {
                ForgeWailaClient.onServerLogout(connection);
            }
        }
    }
}

