/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.provider;

import java.util.Optional;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IModInfo;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.api.component.ItemComponent;
import mcp.mobius.waila.mixin.ChiseledBookShelfBlockAccess;
import mcp.mobius.waila.plugin.vanilla.config.Options;
import mcp.mobius.waila.plugin.vanilla.provider.ItemEntityProvider;
import mcp.mobius.waila.plugin.vanilla.provider.data.ChiseledBookShelfDataProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;

public enum ChiseledBookShelfProvider implements IBlockComponentProvider
{
    INSTANCE;

    private int lastUpdateId = 0;
    private ItemStack hitItem = ItemStack.f_41583_;

    private void init(IBlockAccessor accessor, IPluginConfig config) {
        if (this.lastUpdateId == accessor.getUpdateId()) {
            return;
        }
        this.lastUpdateId = accessor.getUpdateId();
        this.hitItem = ItemStack.f_41583_;
        if (!config.getBoolean(Options.BOOK_BOOKSHELF)) {
            return;
        }
        ChiseledBookShelfDataProvider.Data data = accessor.getData().get(ChiseledBookShelfDataProvider.Data.class);
        if (data == null) {
            return;
        }
        BlockState blockstate = accessor.getBlockState();
        Direction facing = (Direction)blockstate.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        Optional<Vec2> relativeHit = ChiseledBookShelfBlockAccess.wthit_getRelativeHitCoordinatesForBlockFace(accessor.getBlockHitResult(), facing);
        if (relativeHit.isEmpty()) {
            return;
        }
        int hitSlot = ChiseledBookShelfBlockAccess.wthit_getHitSlot(relativeHit.get());
        this.hitItem = data.items().get(hitSlot);
    }

    @Override
    @Nullable
    public ITooltipComponent getIcon(IBlockAccessor accessor, IPluginConfig config) {
        this.init(accessor, config);
        if (this.hitItem.m_41619_()) {
            return null;
        }
        return new ItemComponent(this.hitItem);
    }

    @Override
    public void appendHead(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        this.init(accessor, config);
        if (this.hitItem.m_41619_()) {
            return;
        }
        IWailaConfig.Formatter formatter = IWailaConfig.get().getFormatter();
        tooltip.setLine(WailaConstants.OBJECT_NAME_TAG, formatter.entityName(this.hitItem.m_41786_()));
        if (config.getBoolean(WailaConstants.CONFIG_SHOW_REGISTRY)) {
            tooltip.setLine(WailaConstants.REGISTRY_NAME_TAG, formatter.registryName(BuiltInRegistries.f_257033_.m_7981_((Object)this.hitItem.m_41720_())));
        }
    }

    @Override
    public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        this.init(accessor, config);
        if (this.hitItem.m_41619_()) {
            return;
        }
        ItemEntityProvider.appendBookProperties(tooltip, this.hitItem, config);
    }

    @Override
    public void appendTail(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        this.init(accessor, config);
        if (this.hitItem.m_41619_()) {
            return;
        }
        if (!config.getBoolean(WailaConstants.CONFIG_SHOW_MOD_NAME)) {
            return;
        }
        tooltip.setLine(WailaConstants.MOD_NAME_TAG, IWailaConfig.get().getFormatter().modName(IModInfo.get(this.hitItem).getName()));
    }
}

