/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.service;

import com.google.common.collect.Streams;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Stream;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IBlacklistConfig;
import mcp.mobius.waila.api.IInstanceRegistry;
import mcp.mobius.waila.api.IJsonConfig;
import mcp.mobius.waila.api.IModInfo;
import mcp.mobius.waila.api.IPluginInfo;
import mcp.mobius.waila.api.IRegistryFilter;
import mcp.mobius.waila.api.ITheme;
import mcp.mobius.waila.api.IThemeType;
import mcp.mobius.waila.api.__internal__.IApiService;
import mcp.mobius.waila.config.JsonConfig;
import mcp.mobius.waila.gui.hud.TooltipRenderer;
import mcp.mobius.waila.gui.hud.theme.ThemeType;
import mcp.mobius.waila.mixin.GuiAccess;
import mcp.mobius.waila.plugin.PluginInfo;
import mcp.mobius.waila.registry.InstanceRegistry;
import mcp.mobius.waila.registry.RegistryFilter;
import mcp.mobius.waila.util.ModInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TippedArrowItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;

public abstract class ApiService
implements IApiService {
    @Override
    public IModInfo getModInfo(ItemStack stack) {
        Item item = stack.m_41720_();
        if ("minecraft".equals(BuiltInRegistries.f_257033_.m_7981_((Object)item).m_135827_())) {
            if (item instanceof EnchantedBookItem) {
                CompoundTag enchantmentNbt;
                ResourceLocation id;
                ListTag enchantmentsNbt = EnchantedBookItem.m_41163_((ItemStack)stack);
                if (enchantmentsNbt.size() == 1 && (id = ResourceLocation.m_135820_((String)(enchantmentNbt = enchantmentsNbt.m_128728_(0)).m_128461_("id"))) != null && BuiltInRegistries.f_256876_.m_7804_(id)) {
                    return IModInfo.get(id.m_135827_());
                }
            } else {
                if (item instanceof PotionItem || item instanceof TippedArrowItem) {
                    Potion potionType = PotionUtils.m_43579_((ItemStack)stack);
                    ResourceLocation id = BuiltInRegistries.f_256980_.m_7981_((Object)potionType);
                    return IModInfo.get(id.m_135827_());
                }
                if (item instanceof SpawnEggItem) {
                    SpawnEggItem spawnEggItem = (SpawnEggItem)item;
                    ResourceLocation id = BuiltInRegistries.f_256780_.m_7981_((Object)spawnEggItem.m_43228_(null));
                    return IModInfo.get(id.m_135827_());
                }
            }
        }
        return IModInfo.get(item);
    }

    @Override
    public IBlacklistConfig getBlacklistConfig() {
        return Waila.BLACKLIST_CONFIG.get().getView();
    }

    @Override
    public <T> IJsonConfig.Builder0<T> createConfigBuilder(Type type) {
        return new JsonConfig.Builder(type);
    }

    @Override
    public IModInfo getModInfo(String namespace) {
        return ModInfo.get(namespace);
    }

    @Override
    public IPluginInfo getPluginInfo(ResourceLocation pluginId) {
        return PluginInfo.get(pluginId);
    }

    @Override
    public Collection<IPluginInfo> getAllPluginInfoFromMod(String modId) {
        return PluginInfo.getAllFromMod(modId);
    }

    @Override
    public Collection<IPluginInfo> getAllPluginInfo() {
        return PluginInfo.getAll();
    }

    @Override
    public int getPairComponentColonOffset() {
        return TooltipRenderer.colonOffset;
    }

    @Override
    public int getColonFontWidth() {
        return TooltipRenderer.colonWidth;
    }

    @Override
    public int getFontColor() {
        return TooltipRenderer.state.getTheme().getDefaultTextColor();
    }

    @Override
    public <T extends ITheme> IThemeType.Builder<T> createThemeTypeBuilder(Class<T> clazz) {
        return new ThemeType<T>(clazz);
    }

    @Override
    public String getDefaultEnergyUnit() {
        return "E";
    }

    @Override
    public Path getConfigDir() {
        return Waila.CONFIG_DIR;
    }

    @Override
    public ResourceLocation getGuiIconsTexture() {
        return GuiAccess.wthit_guiIconsLocation();
    }

    @Override
    public <T> IRegistryFilter.Builder<T> createRegistryFilterBuilder(ResourceKey<? extends Registry<T>> registryKey) {
        return new RegistryFilter.Builder(registryKey);
    }

    @Override
    public <T> IInstanceRegistry<T> createInstanceRegistry(boolean reversed) {
        InstanceRegistry registry = new InstanceRegistry();
        if (reversed) {
            registry.reversed();
        }
        return registry;
    }

    @Override
    public List<Tier> getTiers() {
        List<Tiers> vanilla = List.of(Tiers.values());
        LinkedHashSet<Tier> custom = new LinkedHashSet<Tier>();
        for (Item item : BuiltInRegistries.f_257033_) {
            TieredItem tiered;
            if (!(item instanceof TieredItem) || (tiered = (TieredItem)item).m_43314_() instanceof Tiers) continue;
            custom.add(tiered.m_43314_());
        }
        return Streams.concat((Stream[])new Stream[]{vanilla.stream(), custom.stream()}).sorted(Comparator.comparingInt(Tier::m_6604_)).toList();
    }
}

